import { initializeApp } from "https://www.gstatic.com/firebasejs/9.6.1/firebase-app.js";
import { getFirestore, collection, onSnapshot } from "https://www.gstatic.com/firebasejs/9.6.1/firebase-firestore.js";

const firebaseConfig = {
    apiKey: "YOUR_KEY",
    authDomain: "YOUR_DOMAIN",
    projectId: "YOUR_PROJECT_ID"
};

const app = initializeApp(firebaseConfig);
const db = getFirestore(app);

const listDiv = document.getElementById("list");

onSnapshot(collection(db, "picks"), (snapshot) => {
    let html = "";
    snapshot.forEach(doc => {
        const d = doc.data();
        html += `<p>${d.name} - ${d.mobile} - Card ${d.number}</p>`;
    });
    listDiv.innerHTML = html;
});