import { initializeApp } from "https://www.gstatic.com/firebasejs/9.6.1/firebase-app.js";
import { getFirestore, collection, getDocs, doc, setDoc } from "https://www.gstatic.com/firebasejs/9.6.1/firebase-firestore.js";

const firebaseConfig = {
    apiKey: "YOUR_KEY",
    authDomain: "YOUR_DOMAIN",
    projectId: "YOUR_PROJECT_ID"
};

const app = initializeApp(firebaseConfig);
const db = getFirestore(app);

let shuffledNumbers = [];

const startBtn = document.getElementById("startBtn");
startBtn.addEventListener("click", startGame);

async function startGame() {
    const name = document.getElementById("name").value;
    const mobile = document.getElementById("mobile").value;
    if (!name || !mobile) return alert("Enter name & mobile");

    shuffledNumbers = [...Array(14).keys()].map(n => n+1).sort(() => Math.random() - 0.5);

    document.getElementById("form").style.display = "none";

    await renderCards();
}

async function renderCards() {
    const takenSnapshot = await getDocs(collection(db, "picks"));
    const takenNumbers = takenSnapshot.docs.map(d => d.id);

    const container = document.getElementById("cards");
    container.innerHTML = "";

    shuffledNumbers.forEach(num => {
        const card = document.createElement("div");
        card.className = "card";
        card.innerHTML = `<div class='inner'><div class='front'>LOGO</div><div class='back'>${num}</div></div>`;

        if (!takenNumbers.includes(num.toString())) {
            card.addEventListener("click", () => pickCard(card, num));
        } else {
            card.style.opacity = 0.3;
        }

        container.appendChild(card);
    });
}

async function pickCard(card, number) {
    card.classList.add("flip");
    const name = document.getElementById("name").value;
    const mobile = document.getElementById("mobile").value;

    await setDoc(doc(db, "picks", number.toString()), {
        name,
        mobile,
        number,
        time: new Date()
    });

    const msg = `New Pick: ${name} chose card ${number}`;
    window.open(`https://api.callmebot.com/whatsapp.php?phone=YOURNUMBER&text=${encodeURIComponent(msg)}&apikey=YOURAPIKEY`);
}